/**
* \file: Sensors.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADIT/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef SENSORS_H
#define SENSORS_H

#include <map>
#include <string>
#include <atomic>
#include <sys/time.h>
#include <unistd.h>
#include <aauto/util/scoped_ptr.h>
#include <aauto/SensorSource.h>
#include <aauto/util/Mutex.h>
#include "VirtualSensorSource.h"

#define     SData_1e6   1000000
#define     SData_1e3   1000

#define     NSEC_PER_SEC    (1000ULL * 1000ULL * 1000ULL)


namespace adit { namespace aauto {


// Night Mode test class
class NightModeData : public SensorTest
{
public:
    NightModeData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    bool nightModeFlag;
};

// Speed data test class
class SpeedData : public SensorTest
{
public:
    SpeedData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t speedDataCount;
    bool hasCruiseEngaged;
    bool cruiseEngaged;
    bool hasCruiseSetSpeed;
    int32_t cruiseSetSpeed;
};

// Compass data test class
class CompassData : public SensorTest
{
public:
    CompassData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t compassDataCount;
    int32_t compassDataCount3D;
    int32_t pitchE6;
    int32_t rollE6;
};

// RPM data test class
class RPMData : public SensorTest
{
public:
    RPMData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t rpmDataCount;
};

// Fuel data test class
class FuelData : public SensorTest
{
public:
    FuelData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t fuelRemainingPercent;
};

// Odometer data test class
class OdometerData : public SensorTest
{
public:
    OdometerData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t odometerDataCount;
    bool hasTripKms;
    int32_t tripKmsE1;
};

// ParkingBrake data test class
class ParkingBrakeData : public SensorTest
{
public:
    ParkingBrakeData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    bool parkingBrakeFlag;
    int32_t parkingBrakeIntervalCount;
};
    
// Gear data test class
class GearData : public SensorTest
{
public:
    GearData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t GearDataWait;
    uint32_t GearDataCount;
};
    
// Door data test class
class DoorData : public SensorTest
{
public:
    DoorData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    bool HoodOpenFlag;
    bool trunkOpenFlag;
    uint32_t DoorDataCount;
};

// Driving status data test class
class DrivingStatusData : public SensorTest
{
public:
    DrivingStatusData(bool inVerbose, sensorTable& inSensor);
    int ExecTest(sensorTestMode& testMode);

private:
    int32_t drivingStatus;
};

// Location data test class
typedef struct locationData_detail_type
{
    int32_t     latitudeE7;
    int32_t     longitudeE7;
} locationData_detail;

typedef struct locationData_type
{
    locationData_detail position;   // start position
    int32_t     incDecCount;        // increment/decrement count
    int32_t     accuracyE3;         // accuracy
    int32_t     altitudeE2;         // meters above sea level
    int32_t     speedE3;            // m/s absolute velocity (meter/second)
    int32_t     bearingE6;          // compass bearing
} sensorLocationData;

// Location data to navigate application on the android auto
class LocationNaviData
{
public:
    LocationNaviData(std::string cityname, bool inVerbose);
    ~LocationNaviData() {};

    sensorLocationData getLocationData();
    bool isLocationDataEmpty();
    void initilizeLocation();
    void updateLocation();
    void updatePosition();

    int getLatitude()   { return latitude;  }
    int getLongitude()  { return longitude; }
    int getLocCount()   { return locCount;  }
    std::string getLocName() { return cityName;  }
    
private:
    std::map<int, sensorLocationData> locationData;
    std::string  cityName;

    int32_t posCount;
    uint32_t incDecLat;
    uint32_t incDecLong;

    uint32_t locCount;
    int32_t locDataMax;
    int32_t latitude;
    int32_t longitude;
    
    bool verbose;
};

class LocationData : public SensorTest
{
public:
    LocationData(bool inVerbose, sensorTable& inSensor, std::string inLocationStr);
    int ExecTest(sensorTestMode& testMode);

private:
    ::scoped_ptr<LocationNaviData> locData;
};

} } /* namespace adit { namespace aauto { */

#endif /* SENSORS_H */
